//////////////////////////////////////////////////////////////////////////
// This is a clean prefpage with a treeoption control 
// I avoided unnecessary code obfuscation as good as possible
#include "stdafx.h"
#include "emule.h"
#include "Version.h" 
#include "Sion/Cp/PreferencesDlg.h"
#include "PPgeMuleFuture.h"
#include "./AntiLeech/Modname.h"
#include "UserMsgs.h"
#include "otherfunctions.h"
#include "UploadQueue.h" // VQB: fullChunk
//>>> WiZaRd::AutoHL
#include "PartFile.h"
#include "DownloadQueue.h" 
//<<< WiZaRd::AutoHL
//>>> WiZaRd::PNCheck/EMF
#include "eMuleFuture.h"
#include "emuleDlg.h"
#include "ChatWnd.h"
#include "FriendListCtrl.h"
#include "MenuCmds.h"
//<<< WiZaRd::PNCheck/EMF
#include "./ConChecker/ConChecker.h" //>>> WiZaRd::ConChecker [eWombat]
#include "EMF/IP2Country.h"	//>>> shadow2004::IP2Country [EastShare]

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#define new DEBUG_NEW
#endif

#define HIDDEN_PASSWORD _T("*****") //>>> WiZaRd::PNCheck/EMF


IMPLEMENT_DYNAMIC(CPPgeMuleFuture, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgeMuleFuture, CPropertyPage)
	ON_WM_HSCROLL()	
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify) // NEO: FIX - [TreeControl]
END_MESSAGE_MAP()

CPPgeMuleFuture::CPPgeMuleFuture()
: CPropertyPage(CPPgeMuleFuture::IDD)
, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{

	m_htiMoreTweaksGroup = NULL;

	m_htiMultipleInstances = NULL;
	m_bMultipleInstances = false;

	m_htiClientDataRate = NULL;
	m_uiClientDataRate = 0;

	m_htiFUChunks = NULL;
	m_uiFUChunks = 0;

//>>> WiZaRd::AutoHL
	m_htiAutoHL = NULL;

	m_htiUseAutoHLRadio = NULL;
	m_htiUseAutoHLPerFile = NULL;
	m_htiUseAutoHLOn = NULL;
	m_htiUseAutoHLOff = NULL;
	m_iUseAutoHL = 0;

	m_htiMaxSources = NULL;
	m_iMaxSources = 0;

	m_htiMaxPerFileSources = NULL;
	m_iMaxPerFileSources = 0;

	m_htiMinPerFileSources = NULL;
	m_iMinPerFileSources = 0;

	m_htiAHLUpdate = NULL;
	m_iAHLUpdate = 0;
//<<< WiZaRd::AutoHL

//>>> WiZaRd::Payback first	
	m_htiPaybackFirstRadio = NULL;
	m_htiPaybackDisabled = NULL;
	m_htiPaybackConst = NULL;
	m_htiPaybackVar = NULL;
	m_htiPaybackAuto = NULL;
	m_iPaybackFirst = 0;
//<<< WiZaRd::Payback first

//>>> Spike2::Emulate other
	m_htiEmulateGroup = NULL;

	m_htiEmulateEdonkey = NULL;
	m_htiEmulateEdonkeyHybrid = NULL;
	m_htiEmulateMLdonkey = NULL;
	m_htiEmulateShareaza = NULL;
	m_htiEmulateLphant = NULL;
//<<< Spike2::Emulate other

//>>> WiZaRd::PNCheck/EMF
	m_htiEMFSupport = NULL;
	m_htiUserName = NULL;
	m_htiUserPW = NULL;
	m_htiCheckPNs = NULL;
	m_htiFriendsEntry = NULL;
	m_htiAutoUpdateFriends = NULL;

	m_sUserName = _T("");
	m_sUserPW = _T("");
	m_bCheckPNs = false;
	m_bFriendsEntry = false;
	m_bAutoUpdateFriends = false;
//<<< WiZaRd::PNCheck/EMF

//>>> shadow2004::Toolbar
	m_htiDisplayGroup = NULL;
	m_htiTLabel = NULL;
	m_htiTLabelOn = NULL;
	m_htiTLabelOff = NULL;
	m_htiTLabelActive = NULL;
	m_htiTLabelOver = NULL;
	m_htiTLabelMulti = NULL;
	m_iToolbarLabelStyle = 0;
//<<< shadow2004::Toolbar

//>>> shadow2004::IP2Country [EastShare]
	m_htiI2CGroup = NULL;
	m_htiI2C2Letter = NULL;
	m_htiI2C3Letter = NULL;
	m_htiI2CFullCaption = NULL;
	m_htiI2CShowFlag = NULL;
	m_iI2CCaption = 0;
	m_bI2CShowFlag = false;
//<<< shadow2004::IP2Country [EastShare]

//>>> WiZaRd::IntelliFlush
	m_htiSystemGroup = NULL;
	m_htiFileBufferGroup = NULL;
	m_htiFileBufferSize = NULL;
	m_htiFileBufferTime = NULL;
	m_htiIntelliFlushCheck = NULL;
	m_iFileBufferSize = 0;
	m_iFileBufferTime = 0;
	m_bIntelliFlush = false;
//<<< WiZaRd::IntelliFlush

//>>> WiZaRd::ConChecker [eWombat]
	m_htiConcheckerGroup = NULL;
	m_htiConcheckerActive = NULL;
	m_htiConcheckerPingtypeRadio = NULL;
	m_htiConcheckerPingICMP = NULL;
	m_htiConcheckerPingRAW = NULL;
	m_htiConcheckerTTL = NULL;
	m_htiConcheckerPingtimeout = NULL;
	m_bConcheckerActive = false;
	m_iConcheckerPingtype = 0;
	m_iConcheckerTTL = 0;
	m_iConcheckerPingtimeout = 0;
//<<< WiZaRd::ConChecker [eWombat]

//>>> JvA::SLS [enkeyDEV]
	m_htiSLSGroup = NULL;
	m_htiSLSCheck = NULL;
	m_htiSLSActivationLimit = NULL;
	m_htiSLSSaveValue = NULL;
	m_bSLSCheck = false;
	m_iSLSActivationLimit = 0;
	m_iSLSSaveValue = 0;
//<<< JvA::SLS [enkeyDEV]

//>>> shadow2004::FDC [BlueSonicBoy]
	m_htiFDCGroup		= NULL;
	m_htiFDCEnabled		= NULL;
	m_htiFDCDouble		= NULL;
	m_htiFDCSensitivity = NULL;
	m_bFDCEnabled		= false;
	m_bFDCDouble		= false;
	m_iFDCSense			= 0;
//<<< shadow2004::FDC [BlueSonicBoy]

//>>> shadow2004::minQR [CB]
	m_htiMinQR = NULL;
	m_bUseMinQR = false;
//<<< shadow2004::minQR [CB]

//>>> shadow2004::InfiniteQueue [SLUGFILLER]
	m_htiInfiniteQueue = NULL;
	m_bInfiniteQueue = false;
//<<< shadow2004::InfiniteQueue [SLUGFILLER]

	m_bInitializedTreeOpts = false;
}

CPPgeMuleFuture::~CPPgeMuleFuture()
{
}

void CPPgeMuleFuture::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EMULEFUTURE_OPTS, m_ctrlTreeOptions);
	CString buffer;
	if (!m_bInitializedTreeOpts)
	{
		int iImgDynup = 8;
		int iImgConnection = 8;
		int iImgWiZ = 8;
		int iImgEmulate = 8;
		int iImgAutoHL = 8;
		int iImgDisplay = 8;	//>>> shadow2004::Toolbar
		int iImgToolbar = 8;	//>>> shadow2004::Toolbar
		int iImgDiB = 8;		//>>> WiZaRd/shadow2004::DL in Bold
		int	iImgI2C = 8;		//>>> shadow2004::IP2Country [EastShare]
		int	iImgSLS = 8;		//>>> JvA::SLS [enkeyDEV]
		int iImgFDC = 8;		//>>> shadow2004::FDC [BlueSonicBoy]
//>>> WiZaRd::IntelliFlush
		int iImgSystem = 8; 
		int iImgFileBuffer = 8;
//<<< WiZaRd::IntelliFlush

		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml)
		{
			iImgDynup		=	piml->Add(CTempIconLoader(_T("UPLOAD")));
			iImgConnection	=	piml->Add(CTempIconLoader(_T("connection")));
			iImgWiZ			=	piml->Add(CTempIconLoader(_T("WIZARD")));
			iImgEmulate		=	piml->Add(CTempIconLoader(_T("EMULATE")));
			iImgAutoHL		=	piml->Add(CTempIconLoader(_T("PRIO_AUTO")));
			iImgDisplay		=	piml->Add(CTempIconLoader(_T("DISPLAY"))); //>>> shadow2004::Toolbar
			iImgToolbar		=	piml->Add(CTempIconLoader(_T("SAMEMOD"))); //>>> shadow2004::Toolbar
			iImgDiB			=	piml->Add(CTempIconLoader(_T("BOLD"))); //>>> WiZaRd/shadow2004::DL in Bold
			iImgI2C			=	piml->Add(CTempIconLoader(_T("SEARCHMETHOD_GLOBAL"))); //>>> shadow2004::IP2Country [EastShare]
			iImgSLS			=	piml->Add(CTempIconLoader(_T("SLS")));	//>>> JvA::SLS [enkeyDEV]
			iImgFDC			=	piml->Add(CTempIconLoader(_T("SPAM")));	//>>> shadow2004::FDC [BlueSonicBoy]
//>>> WiZaRd::IntelliFlush
			iImgSystem		=	piml->Add(CTempIconLoader(_T("TWEAK")));
			iImgFileBuffer	=	piml->Add(CTempIconLoader(_T("HARDDISK")));
//<<< WiZaRd::IntelliFlush
		}


		m_htiEMFSupport = m_ctrlTreeOptions.InsertGroup(MOD_BOARD_URL, iImgWiZ, TVI_ROOT);
//>>> WiZaRd::PNCheck/EMF
		m_htiUserName = m_ctrlTreeOptions.InsertItem(GetResString(IDS_QL_USERNAME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiEMFSupport);
		m_ctrlTreeOptions.AddEditBox(m_htiUserName, RUNTIME_CLASS(CTreeOptionsEdit));
		m_htiUserPW = m_ctrlTreeOptions.InsertItem(GetResString(IDS_WS_PASS), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiEMFSupport);
		m_ctrlTreeOptions.AddEditBox(m_htiUserPW, RUNTIME_CLASS(CTreeOptionsEdit));
		m_htiCheckPNs = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMF_CHECKPNS), m_htiEMFSupport, m_bCheckPNs);
		m_htiFriendsEntry = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMF_FRIENDSOPT), m_htiEMFSupport, m_bFriendsEntry);
		m_htiAutoUpdateFriends = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMF_AUTOUPDATEFRIENDS), m_htiEMFSupport, m_bAutoUpdateFriends);
//<<< WiZaRd::PNCheck/EMF

//>>> WiZaRd::IntelliFlush
		m_htiSystemGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SYSTEM), iImgSystem, TVI_ROOT);
		m_htiFileBufferGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_FILEBUFFER), iImgFileBuffer, m_htiSystemGroup);
		buffer.Format(_T("%s [%s]"), GetResString(IDS_FILEBUFFERSIZE), GetResString(IDS_KBYTES));
		m_htiFileBufferSize = m_ctrlTreeOptions.InsertItem(buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFileBufferGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFileBufferSize, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiFileBufferTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_FILEBUFFER_TIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFileBufferGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFileBufferTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiIntelliFlushCheck = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_FILEBUFFER_INTELLI), m_htiFileBufferGroup, m_bIntelliFlush || m_iFileBufferTime < 1 || m_iFileBufferTime > 5);
//<<< WiZaRd::IntelliFlush

//>>> WiZaRd::ConChecker [eWombat]
		m_htiConcheckerGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_CONCHECKER), iImgConnection, TVI_ROOT);
		m_htiConcheckerActive = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CONCHECKER_ACTIVE), m_htiConcheckerGroup, m_bConcheckerActive);
		m_htiConcheckerPingtypeRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_CONCHECKER_PINGMETHOD), iImgSystem, m_htiConcheckerGroup);
		m_htiConcheckerPingICMP = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CONCHECKER_ICMP), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 0);
		m_htiConcheckerPingRAW = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_CONCHECKER_RAW), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 1);
		m_htiConcheckerTTL = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CONCHECKER_TTL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConcheckerGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerTTL, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiConcheckerPingtimeout = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CONCHECKER_TIMEOUT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConcheckerGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerPingtimeout, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< WiZaRd::ConChecker [eWombat]
//>>> shadow2004::InfiniteQueue [SLUGFILLER]
		m_htiInfiniteQueue = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_INFQ_ENABLE), m_htiSystemGroup, m_bInfiniteQueue);
//<<< shadow2004::InfiniteQueue [SLUGFILLER]

		/////////////////////////////////////////////////////////////////////////////
		// More tweaks group
		//
		m_htiMoreTweaksGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PW_MISC), iImgConnection, TVI_ROOT);
		m_htiMultipleInstances = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MULTIPLE_INSTANCES), m_htiMoreTweaksGroup, m_bMultipleInstances);
		m_htiClientDataRate = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DATARATE_ADJUST), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiMoreTweaksGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiClientDataRate, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiFUChunks = m_ctrlTreeOptions.InsertItem(GetResString(IDS_FUCHUNKS), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiMoreTweaksGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFUChunks, RUNTIME_CLASS(CNumTreeOptionsEdit));
//>>> WiZaRd::AutoHL
		m_htiAutoHL = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_AUTOHL), iImgAutoHL, TVI_ROOT);
		m_htiUseAutoHLRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_USE_AUTOHL), iImgDynup, m_htiAutoHL);
		m_htiUseAutoHLPerFile = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PER_FILE), m_htiUseAutoHLRadio, m_iUseAutoHL == 0);
		m_htiUseAutoHLOn = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_OFF), m_htiUseAutoHLRadio, m_iUseAutoHL == 1);
		m_htiUseAutoHLOff = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_ON), m_htiUseAutoHLRadio, m_iUseAutoHL == 2);
		m_htiMaxSources = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MAX_SOURCES), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxSources, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMaxPerFileSources = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MAX_PERFILESOURCES), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxPerFileSources, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMinPerFileSources = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MIN_PERFILESOURCES), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiMinPerFileSources, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAHLUpdate = m_ctrlTreeOptions.InsertItem(GetResString(IDS_AHL_UPDATETIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL);
		m_ctrlTreeOptions.AddEditBox(m_htiAHLUpdate, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< WiZaRd::AutoHL

//>>> WiZaRd::Payback first	
		m_htiPaybackFirstRadio = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PAYBACK_FIRST), iImgDynup, TVI_ROOT);
		m_htiPaybackDisabled = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DISABLED), m_htiPaybackFirstRadio, m_iPaybackFirst == 0);
		m_htiPaybackConst = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_CONST), m_htiPaybackFirstRadio, m_iPaybackFirst == 1);
		m_htiPaybackVar = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_VAR), m_htiPaybackFirstRadio, m_iPaybackFirst == 2);
		m_htiPaybackAuto = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_PAYBACK_FIRST_AUTO), m_htiPaybackFirstRadio, m_iPaybackFirst == 3);
//<<< WiZaRd::Payback first

//>>> Spike2::Emulate other
		m_htiEmulateGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_EMULATE), iImgEmulate, TVI_ROOT);
		m_htiEmulateEdonkey = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_EDONKEY), m_htiEmulateGroup, m_bEmulateEdonkey);
		m_htiEmulateEdonkeyHybrid = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_EDONKEYHYBRID), m_htiEmulateGroup, m_bEmulateEdonkeyHybrid);
		m_htiEmulateMLdonkey = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_MLDONKEY), m_htiEmulateGroup, m_bEmulateMLdonkey);
		m_htiEmulateShareaza = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_SHAREAZA), m_htiEmulateGroup, m_bEmulateShareaza);
		m_htiEmulateLphant = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_EMU_LPHANT), m_htiEmulateGroup, m_bEmulateLphant);
//<<< Spike2::Emulate other

//>>> JvA::SLS [enkeyDEV]
		m_htiSLSGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SLSLABEL), iImgSLS, TVI_ROOT);
		m_htiSLSCheck		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SLSCHECKLABEL), m_htiSLSGroup, m_bSLSCheck);
		m_htiSLSActivationLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSACTIVATIONLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLSGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSActivationLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiSLSSaveValue	= m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSSAVEVALUE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLSGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSSaveValue, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< JvA::SLS [enkeyDEV]
//>>> shadow2004::FDC [BlueSonicBoy]
		m_htiFDCGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_FDCGROUP), iImgFDC, TVI_ROOT);
		m_htiFDCEnabled		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_FDCENABLE), m_htiFDCGroup, m_bFDCEnabled);
		m_htiFDCDouble		= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_FDCDOUBLE), m_htiFDCGroup, m_bFDCDouble);
		m_htiFDCSensitivity = m_ctrlTreeOptions.InsertItem(GetResString(IDS_FDCSENSE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFDCGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiFDCSensitivity, RUNTIME_CLASS(CNumTreeOptionsEdit));
//<<< Tux::FDC [BlueSonicBoy]

//>>> shadow2004::Toolbar
		m_htiDisplayGroup	= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PW_DISPLAY), iImgDisplay, TVI_ROOT);
		m_htiTLabel			= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_TBLABELS), iImgToolbar, m_htiDisplayGroup);
		m_htiTLabelOff		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_TBLABELSOFF), m_htiTLabel, m_iToolbarLabelStyle == 0);
		m_htiTLabelOn		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_TBLABELSON), m_htiTLabel, m_iToolbarLabelStyle == 1);
		m_htiTLabelActive	= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_TBLABELSACTIVE), m_htiTLabel, m_iToolbarLabelStyle == 2);
		m_htiTLabelOver		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_TBLABELSOVER), m_htiTLabel, m_iToolbarLabelStyle == 3);
		m_htiTLabelMulti	= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_TBLABELSMULTI), m_htiTLabel, m_iToolbarLabelStyle == 4);
//<<< shadow2004::Toolbar

//>>> shadow2004::IP2Country [EastShare]
		m_htiI2CGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_IP2COUNTRY), iImgI2C, m_htiDisplayGroup);
		m_htiI2C2Letter		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_2LETTERS), m_htiI2CGroup, m_iI2CCaption == 0);
		m_htiI2C3Letter		= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_3LETTERS), m_htiI2CGroup, m_iI2CCaption == 1);
		m_htiI2CFullCaption	= m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_IP2COUNTRY_FULLCAPTION), m_htiI2CGroup, m_iI2CCaption == 2);
		m_htiI2CShowFlag	= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_IP2COUNTRY_SHOWFLAGS), m_htiI2CGroup, m_bI2CShowFlag);
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::minQR [CB]
		m_htiMinQR			= m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MINQR_ENABLE), m_htiDisplayGroup, m_bUseMinQR);
//<<< shadow2004::minQR [CB]

//Expand Settings
		m_ctrlTreeOptions.Expand(m_htiEMFSupport, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiSystemGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiMoreTweaksGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiDisplayGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiSLSGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiFileBufferGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiConcheckerGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiConcheckerPingtypeRadio, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiAutoHL, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiUseAutoHLRadio, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiPaybackFirstRadio, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiEmulateGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiFDCGroup, TVE_EXPAND);
//		m_ctrlTreeOptions.Expand(m_htiTLabel, TVE_EXPAND);
//Expand Settings

//Bold Settings
		m_ctrlTreeOptions.SetItemState(m_htiFileBufferGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiEMFSupport, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiSLSGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiSystemGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiMoreTweaksGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiDisplayGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiConcheckerGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiConcheckerPingtypeRadio, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiAutoHL, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiUseAutoHLRadio, TVIS_BOLD, TVIS_BOLD);	
		m_ctrlTreeOptions.SetItemState(m_htiPaybackFirstRadio, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiEmulateGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiTLabel, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiI2CGroup, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(m_htiFDCGroup, TVIS_BOLD, TVIS_BOLD);
//Bold Settings

		m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
		m_bInitializedTreeOpts = true;
	}

//>>> WiZaRd::PNCheck/EMF
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiUserName, m_sUserName);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiUserPW, m_sUserPW);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiCheckPNs, m_bCheckPNs);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiFriendsEntry, m_bFriendsEntry);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiAutoUpdateFriends, m_bAutoUpdateFriends);
	BOOL bAuth = thePrefs.IsAuthenticated() ? TRUE : FALSE;
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiCheckPNs, bAuth);
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiFriendsEntry, bAuth);
	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiAutoUpdateFriends, bAuth);
//<<< WiZaRd::PNCheck/EMF

//>>> WiZaRd::IntelliFlush
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiFileBufferSize, m_iFileBufferSize);
	DDV_MinMaxInt(pDX, m_iFileBufferSize, 256, 30*1024); //kB!
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiFileBufferTime, m_iFileBufferTime);
	DDV_MinMaxInt(pDX, m_iFileBufferTime, 0, 60); //minutes!
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiIntelliFlushCheck, m_bIntelliFlush);	
	//hmmm doesn't work - damn those trees!
	if(m_iFileBufferTime < 1 || m_iFileBufferTime > 5) 
	{
		m_ctrlTreeOptions.SetCheckBoxEnable(m_htiIntelliFlushCheck, FALSE);
		m_ctrlTreeOptions.SetCheckBox(m_htiIntelliFlushCheck, TRUE);
	}
	else
	{
		m_ctrlTreeOptions.SetCheckBoxEnable(m_htiIntelliFlushCheck, TRUE);
		m_ctrlTreeOptions.SetCheckBox(m_htiIntelliFlushCheck, m_bIntelliFlush);
	}
//<<< WiZaRd::IntelliFlush

//>>> WiZaRd::ConChecker [eWombat]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerActive, m_bConcheckerActive);	
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerTTL, m_iConcheckerTTL);
	DDV_MinMaxInt(pDX, m_iConcheckerTTL, 8, 64);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerPingtimeout, m_iConcheckerPingtimeout);
	DDV_MinMaxInt(pDX, m_iConcheckerPingtimeout, 1, 64);
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype); 
//<<< WiZaRd::ConChecker [eWombat]
//>>> shadow2004::InfiniteQueue [SLUGFILLER]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiInfiniteQueue, m_bInfiniteQueue);
//<<< shadow2004::InfiniteQueue [SLUGFILLER]

	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiMultipleInstances, m_bMultipleInstances);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiClientDataRate, m_uiClientDataRate);
	DDV_MinMaxInt(pDX, m_uiClientDataRate, 0, thePrefs.GetMaxUpload()/2);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiFUChunks, m_uiFUChunks);
	DDV_MinMaxInt(pDX, m_uiFUChunks, 1, _UI8_MAX);

//>>> WiZaRd::AutoHL
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiUseAutoHLRadio, m_iUseAutoHL); 
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiMaxSources, m_iMaxSources);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiMaxPerFileSources, m_iMaxPerFileSources);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiMinPerFileSources, m_iMinPerFileSources);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiAHLUpdate, m_iAHLUpdate);
	DDV_MinMaxInt(pDX, m_iMaxSources, 1500, _UI16_MAX);
	DDV_MinMaxInt(pDX, m_iMaxPerFileSources, 150, _UI16_MAX);
	DDV_MinMaxInt(pDX, m_iMinPerFileSources, 25, _UI16_MAX);
	DDV_MinMaxInt(pDX, m_iAHLUpdate, 10, 600);
//<<< WiZaRd::AutoHL

//>>> WiZaRd::Payback first	
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiPaybackFirstRadio, m_iPaybackFirst); 
//<<< WiZaRd::Payback first

//>>> Spike2::Emulate other
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateEdonkey, m_bEmulateEdonkey);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateEdonkeyHybrid, m_bEmulateEdonkeyHybrid);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateMLdonkey, m_bEmulateMLdonkey);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateShareaza, m_bEmulateShareaza);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiEmulateLphant, m_bEmulateLphant);
//<<< Spike2::Emulate other

//>>> JvA::SLS [enkeyDEV]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiSLSCheck, m_bSLSCheck);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiSLSActivationLimit, m_iSLSActivationLimit);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiSLSSaveValue, m_iSLSSaveValue);
	DDV_MinMaxInt(pDX, m_iSLSActivationLimit, 0, 100);
	DDV_MinMaxInt(pDX, m_iSLSSaveValue, 0, 50);
//<<< JvA::SLS [enkeyDEV]

//>>> shadow2004::FDC [BlueSonicBoy]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiFDCEnabled, m_bFDCEnabled);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiFDCDouble, m_bFDCDouble);
	DDX_TreeEdit(pDX, IDC_EMULEFUTURE_OPTS, m_htiFDCSensitivity, m_iFDCSense);
	DDV_MinMaxInt(pDX, m_iFDCSense, 6, 30);
//<<< shadow2004::FDC [BlueSonicBoy]

//dlarge Display Settings Settings
//>>> shadow2004::Toolbar
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiTLabel, m_iToolbarLabelStyle);
//<<< shadow2004::Toolbar

//>>> shadow2004::IP2Country [EastShare]
	DDX_TreeRadio(pDX, IDC_EMULEFUTURE_OPTS, m_htiI2CGroup, m_iI2CCaption);
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiI2CShowFlag, m_bI2CShowFlag);
//<<< shadow2004::IP2Country [EastShare]
//dlarge Display Settings Settings

//>>> shadow2004::minQR [CB]
	DDX_TreeCheck(pDX, IDC_EMULEFUTURE_OPTS, m_htiMinQR, m_bUseMinQR);
//<<< shadow2004::minQR [CB]
}

BOOL CPPgeMuleFuture::OnInitDialog()
{
	m_bMultipleInstances = theApp.GetProfileInt(_T("eMule"), _T("IgnoreInstances"), 0) != 0;
	m_uiClientDataRate = thePrefs.GetClientDataRate()/1024;	
	m_uiFUChunks = thePrefs.GetFUChunks();

//>>> WiZaRd::IntelliFlush
	m_iFileBufferSize = thePrefs.GetFileBufferSize()/1024; //kB!
	m_iFileBufferTime = thePrefs.GetFileBufferFlushTime()/60/1000; //minutes!
	m_bIntelliFlush = m_iFileBufferTime < 1 || m_iFileBufferTime > 5 || thePrefs.IsUseIntelliFlush();
//<<< WiZaRd::IntelliFlush

//>>> WiZaRd::ConChecker [eWombat]
	m_bConcheckerActive = thePrefs.GetCheckCon();	
	m_iConcheckerTTL = thePrefs.GetPingTTL();
	m_iConcheckerPingtimeout = thePrefs.GetPingTimeout();
	m_iConcheckerPingtype = thePrefs.GetICMP() ? 0 : 1; 
//<<< WiZaRd::ConChecker [eWombat]

//>>> WiZaRd::AutoHL
	m_iUseAutoHL = thePrefs.IsUseAutoHL()+1;
	m_iMaxSources = thePrefs.GetMaxSourcesHL();
	m_iMaxPerFileSources = thePrefs.GetMaxAutoHL();
	m_iMinPerFileSources = thePrefs.GetMinAutoHL();
	m_iAHLUpdate = thePrefs.GetAutoHLUpdateTimer();
//<<< WiZaRd::AutoHL

//>>> WiZaRd::Payback first	
	m_iPaybackFirst = thePrefs.GetPaybackFirst();
//<<< WiZaRd::Payback first

//>>> Spike2::Emulate other
	m_bEmulateEdonkey = thePrefs.IsEmueDonkey();
	m_bEmulateEdonkeyHybrid = thePrefs.IsEmueDonkeyHybrid();
	m_bEmulateMLdonkey = thePrefs.IsEmuMLDonkey();
	m_bEmulateShareaza = thePrefs.IsEmuShareaza();
	m_bEmulateLphant = thePrefs.IsEmuLphant();
//<<< Spike2::Emulate other

//>>> WiZaRd::PNCheck/EMF
	m_sUserName = thePrefs.GetUserName();
	m_sUserPW = HIDDEN_PASSWORD;
	m_bCheckPNs = thePrefs.IsCheckPNCount(true);
	m_bFriendsEntry = thePrefs.IsFriendlistEntry(true);
	m_bAutoUpdateFriends = thePrefs.IsAutoUpdateFriendList(true);
//<<< WiZaRd::PNCheck/EMF

	m_iToolbarLabelStyle = thePrefs.GetToolbarLabelStyle();	//>>> shadow2004::Toolbar

//>>> shadow2004::IP2Country [EastShare]
	m_iI2CCaption = thePrefs.GetIP2CountryNameMode();
	m_bI2CShowFlag = thePrefs.IsIP2CountryShowFlag();
//<<< shadow2004::IP2Country [EastShare]

//>>> JvA::SLS [enkeyDEV]
	m_bSLSCheck = thePrefs.UseSaveLoadSources();
	m_iSLSActivationLimit = thePrefs.GetActivationLimitSLS();
	m_iSLSSaveValue = thePrefs.GetSourcesToSaveSLS();
//<<< JvA::SLS [enkeyDEV]

//>>> shadow2004::FDC [BlueSonicBoy]
	m_bFDCEnabled		= thePrefs.GetFDCEnabled();
	m_bFDCDouble		= thePrefs.GetFDCDoubleEnabled();
	m_iFDCSense			= 100 - thePrefs.GetFDCSensitivity();
//<<< shadow2004::FDC [BlueSonicBoy]

//>>> shadow2004::minQR [CB]
	m_bUseMinQR = thePrefs.ShowMinQR();
//<<< shadow2004::minQR [CB]

//>>> shadow2004::InfiniteQueue [SLUGFILLER]
	m_bInfiniteQueue = thePrefs.IsInfiniteQueueEnabled();
//<<< shadow2004::InfiniteQueue [SLUGFILLER]

	InitWindowStyles(this);
	CPropertyPage::OnInitDialog();
	Localize();
	LoadSettings();
	return TRUE;

}

BOOL CPPgeMuleFuture::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

void CPPgeMuleFuture::Localize(void)
{	
	if(m_hWnd)
	{
		CString buffer;
		SetWindowText(VERSION_MOD);

		if (m_htiMoreTweaksGroup) m_ctrlTreeOptions.SetItemText(m_htiMoreTweaksGroup, GetResString(IDS_PW_MISC));
		if (m_htiMultipleInstances) m_ctrlTreeOptions.SetItemText(m_htiMultipleInstances, GetResString(IDS_MULTIPLE_INSTANCES));
		if (m_htiClientDataRate) m_ctrlTreeOptions.SetEditLabel(m_htiClientDataRate, GetResString(IDS_DATARATE_ADJUST));
		if (m_htiFUChunks) m_ctrlTreeOptions.SetEditLabel(m_htiFUChunks, GetResString(IDS_FUCHUNKS));

//>>> WiZaRd::IntelliFlush
		if (m_htiSystemGroup) m_ctrlTreeOptions.SetItemText(m_htiSystemGroup, GetResString(IDS_SYSTEM));
		if (m_htiFileBufferGroup) m_ctrlTreeOptions.SetItemText(m_htiFileBufferGroup, GetResString(IDS_FILEBUFFER));
		if (m_htiFileBufferSize) 
		{
			buffer.Format(_T("%s [%s]"), GetResString(IDS_FILEBUFFERSIZE), GetResString(IDS_KBYTES));
			m_ctrlTreeOptions.SetEditLabel(m_htiFileBufferSize, buffer);
		}
		if (m_htiFileBufferTime)	m_ctrlTreeOptions.SetEditLabel(m_htiFileBufferTime, GetResString(IDS_FILEBUFFER_TIME));
		if (m_htiIntelliFlushCheck) m_ctrlTreeOptions.SetItemText(m_htiIntelliFlushCheck, GetResString(IDS_FILEBUFFER_INTELLI));
//<<< WiZaRd::IntelliFlush

//>>> WiZaRd::ConChecker [eWombat]
		if (m_htiConcheckerGroup)		m_ctrlTreeOptions.SetItemText(m_htiConcheckerGroup, GetResString(IDS_CONCHECKER));
		if (m_htiConcheckerActive)		m_ctrlTreeOptions.SetItemText(m_htiConcheckerActive, GetResString(IDS_CONCHECKER_ACTIVE));
		if (m_htiConcheckerPingtypeRadio) m_ctrlTreeOptions.SetItemText(m_htiConcheckerPingtypeRadio, GetResString(IDS_CONCHECKER_PINGMETHOD));
		if (m_htiConcheckerPingICMP)	m_ctrlTreeOptions.SetItemText(m_htiConcheckerPingICMP, GetResString(IDS_CONCHECKER_ICMP));
		if (m_htiConcheckerPingRAW)		m_ctrlTreeOptions.SetItemText(m_htiConcheckerPingRAW, GetResString(IDS_CONCHECKER_RAW));
		if (m_htiConcheckerTTL)			m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerTTL, GetResString(IDS_CONCHECKER_TTL));
		if (m_htiConcheckerPingtimeout) m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerPingtimeout, GetResString(IDS_CONCHECKER_TIMEOUT));
//<<< WiZaRd::ConChecker [eWombat]

//>>> WiZaRd::AutoHL
		if (m_htiAutoHL) m_ctrlTreeOptions.SetItemText(m_htiAutoHL, GetResString(IDS_AUTOHL));
		if (m_htiUseAutoHLRadio) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLRadio, GetResString(IDS_USE_AUTOHL));
		if (m_htiUseAutoHLPerFile) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLPerFile, GetResString(IDS_PER_FILE));
		if (m_htiUseAutoHLOn) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLOn, GetResString(IDS_OFF));
		if (m_htiUseAutoHLOff) m_ctrlTreeOptions.SetItemText(m_htiUseAutoHLOff, GetResString(IDS_ON));
		if (m_htiMaxSources) m_ctrlTreeOptions.SetEditLabel(m_htiMaxSources, GetResString(IDS_MAX_SOURCES));
		if (m_htiMaxPerFileSources) m_ctrlTreeOptions.SetEditLabel(m_htiMaxPerFileSources, GetResString(IDS_MAX_PERFILESOURCES));
		if (m_htiMinPerFileSources) m_ctrlTreeOptions.SetEditLabel(m_htiMinPerFileSources, GetResString(IDS_MIN_PERFILESOURCES));
		if (m_htiAHLUpdate) m_ctrlTreeOptions.SetEditLabel(m_htiAHLUpdate, GetResString(IDS_AHL_UPDATETIME));
//<<< WiZaRd::AutoHL

//>>> WiZaRd::Payback first	
		if (m_htiPaybackFirstRadio) m_ctrlTreeOptions.SetItemText(m_htiPaybackFirstRadio, GetResString(IDS_PAYBACK_FIRST));
		if (m_htiPaybackDisabled) m_ctrlTreeOptions.SetItemText(m_htiPaybackDisabled, GetResString(IDS_DISABLED));
		if (m_htiPaybackConst) m_ctrlTreeOptions.SetItemText(m_htiPaybackConst, GetResString(IDS_PAYBACK_FIRST_CONST));
		if (m_htiPaybackVar) m_ctrlTreeOptions.SetItemText(m_htiPaybackVar, GetResString(IDS_PAYBACK_FIRST_VAR));
		if (m_htiPaybackAuto) m_ctrlTreeOptions.SetItemText(m_htiPaybackAuto, GetResString(IDS_PAYBACK_FIRST_AUTO));
//<<< WiZaRd::Payback first

//>>> Spike2::Emulate other
		if (m_htiEmulateGroup) m_ctrlTreeOptions.SetItemText(m_htiEmulateGroup, GetResString(IDS_EMULATE));
		if (m_htiEmulateEdonkey) m_ctrlTreeOptions.SetItemText(m_htiEmulateEdonkey, GetResString(IDS_EMU_EDONKEY));
		if (m_htiEmulateEdonkeyHybrid) m_ctrlTreeOptions.SetItemText(m_htiEmulateEdonkeyHybrid, GetResString(IDS_EMU_EDONKEYHYBRID));
		if (m_htiEmulateMLdonkey) m_ctrlTreeOptions.SetItemText(m_htiEmulateMLdonkey, GetResString(IDS_EMU_MLDONKEY));
		if (m_htiEmulateShareaza) m_ctrlTreeOptions.SetItemText(m_htiEmulateShareaza, GetResString(IDS_EMU_SHAREAZA));
		if (m_htiEmulateLphant) m_ctrlTreeOptions.SetItemText(m_htiEmulateLphant, GetResString(IDS_EMU_LPHANT));
//<<< Spike2::Emulate other

//>>> WiZaRd::PNCheck/EMF
		if (m_htiUserName) m_ctrlTreeOptions.SetEditLabel(m_htiUserName, GetResString(IDS_QL_USERNAME));
		if (m_htiUserPW) m_ctrlTreeOptions.SetEditLabel(m_htiUserPW, GetResString(IDS_WS_PASS));
		if (m_htiCheckPNs) m_ctrlTreeOptions.SetItemText(m_htiCheckPNs, GetResString(IDS_EMF_CHECKPNS));
		if (m_htiFriendsEntry) m_ctrlTreeOptions.SetItemText(m_htiFriendsEntry, GetResString(IDS_EMF_FRIENDSOPT));
		if (m_htiAutoUpdateFriends) m_ctrlTreeOptions.SetItemText(m_htiAutoUpdateFriends, GetResString(IDS_EMF_AUTOUPDATEFRIENDS));
//<<< WiZaRd::PNCheck/EMF

//>>> shadow2004::Toolbar
		if(m_htiDisplayGroup) m_ctrlTreeOptions.SetItemText(m_htiDisplayGroup, GetResString(IDS_PW_DISPLAY));
		if(m_htiTLabel) m_ctrlTreeOptions.SetItemText(m_htiTLabel, GetResString(IDS_TBLABELS));
		if(m_htiTLabelOff) m_ctrlTreeOptions.SetItemText(m_htiTLabelOff, GetResString(IDS_TBLABELSOFF));
		if(m_htiTLabelOn) m_ctrlTreeOptions.SetItemText(m_htiTLabelOn, GetResString(IDS_TBLABELSON));
		if(m_htiTLabelActive) m_ctrlTreeOptions.SetItemText(m_htiTLabelActive, GetResString(IDS_TBLABELSACTIVE));
		if(m_htiTLabelOver) m_ctrlTreeOptions.SetItemText(m_htiTLabelOver, GetResString(IDS_TBLABELSOVER));
		if(m_htiTLabelMulti) m_ctrlTreeOptions.SetItemText(m_htiTLabelMulti, GetResString(IDS_TBLABELSMULTI));
//<<< shadow2004::Toolbar

//>>> shadow2004::IP2Country [EastShare]
		if(m_htiI2CGroup) m_ctrlTreeOptions.SetItemText(m_htiI2CGroup, GetResString(IDS_IP2COUNTRY));
		if(m_htiI2C2Letter) m_ctrlTreeOptions.SetItemText(m_htiI2C2Letter, GetResString(IDS_IP2COUNTRY_2LETTERS));
		if(m_htiI2C3Letter) m_ctrlTreeOptions.SetItemText(m_htiI2C3Letter, GetResString(IDS_IP2COUNTRY_3LETTERS));
		if(m_htiI2CFullCaption) m_ctrlTreeOptions.SetItemText(m_htiI2CFullCaption, GetResString(IDS_IP2COUNTRY_FULLCAPTION));
		if(m_htiI2CShowFlag) m_ctrlTreeOptions.SetItemText(m_htiI2CShowFlag, GetResString(IDS_IP2COUNTRY_SHOWFLAGS));
//<<< shadow2004::IP2Country [EastShare]

//>>> JvA::SLS [enkeyDEV]
		if(m_htiSLSGroup) m_ctrlTreeOptions.SetItemText(m_htiSLSGroup, GetResString(IDS_SLSLABEL));
		if(m_htiSLSCheck) m_ctrlTreeOptions.SetItemText(m_htiSLSCheck, GetResString(IDS_SLSCHECKLABEL));
		if(m_htiSLSActivationLimit) m_ctrlTreeOptions.SetEditLabel(m_htiSLSActivationLimit, GetResString(IDS_SLSACTIVATIONLABEL));
		if(m_htiSLSSaveValue) m_ctrlTreeOptions.SetEditLabel(m_htiSLSSaveValue, GetResString(IDS_SLSSAVEVALUE));
//<<< JvA::SLS [enkeyDEV]

//>>> shadow2004::minQR [CB]
		if(m_htiMinQR) m_ctrlTreeOptions.SetItemText(m_htiMinQR, GetResString(IDS_MINQR_ENABLE));
//<<< shadow2004::minQR [CB]

//>>> shadow2004::InfiniteQueue [SLUGFILLER]
		if(m_htiInfiniteQueue) m_ctrlTreeOptions.SetItemText(m_htiInfiniteQueue, GetResString(IDS_INFQ_ENABLE));
//<<< shadow2004::InfiniteQueue [SLUGFILLER]

//>>> shadow2004::FDC [BlueSonicBoy]
		if(m_htiFDCGroup) m_ctrlTreeOptions.SetItemText(m_htiFDCGroup, GetResString(IDS_FDCGROUP));
		if(m_htiFDCEnabled)	m_ctrlTreeOptions.SetItemText(m_htiFDCEnabled, GetResString(IDS_FDCENABLE));
		if(m_htiFDCDouble) m_ctrlTreeOptions.SetItemText(m_htiFDCDouble, GetResString(IDS_FDCDOUBLE));
		if(m_htiFDCSensitivity) m_ctrlTreeOptions.SetEditLabel(m_htiFDCSensitivity, GetResString(IDS_FDCSENSE));
//<<< shadow2004::FDC [BlueSonicBoy]

	}
}


BOOL CPPgeMuleFuture::OnApply()
{
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;


	theApp.WriteProfileInt(_T("eMule"), _T("IgnoreInstances"), m_bMultipleInstances ? 1 : 0);
	if(m_uiClientDataRate != 0)
		m_uiClientDataRate = max(m_uiClientDataRate, 3);
	thePrefs.SetClientDataRate((uint16)(m_uiClientDataRate*1024));
	if(thePrefs.GetFUChunks() != (uint8)m_uiFUChunks)
	{
		thePrefs.SetFUChunks((uint8)m_uiFUChunks);
		theApp.uploadqueue->UpdateRemainingUp(); // VQB: fullChunk
	}

//>>> WiZaRd::IntelliFlush
	thePrefs.SetFileBufferSize(m_iFileBufferSize*1024);
	thePrefs.SetFileBufferFlushTime(m_iFileBufferTime*60*1000);
	thePrefs.SetUseIntelliFlush(m_bIntelliFlush || m_iFileBufferTime < 1 || m_iFileBufferTime > 5);
//<<< WiZaRd::IntelliFlush
//>>> WiZaRd::ConChecker [eWombat]
	const bool bSetPrefs = m_iConcheckerTTL != thePrefs.GetPingTTL()
		|| m_iConcheckerPingtimeout != thePrefs.GetPingTimeout()
		|| (uint8)m_iConcheckerPingtype != (thePrefs.GetICMP() ? 0 : 1);
	thePrefs.SetPingTTL((uint8)m_iConcheckerTTL);
	thePrefs.SetPingTimeout((uint8)m_iConcheckerPingtimeout);
	thePrefs.SetICMP(m_iConcheckerPingtype == 0); 
	if(m_bConcheckerActive != thePrefs.GetCheckCon())
	{
		thePrefs.SetCheckCon(m_bConcheckerActive);
		if(m_bConcheckerActive)
			theApp.conchecker.Start();
		else
			theApp.conchecker.Stop();
	}
	else if(bSetPrefs)
		theApp.conchecker.SetPreferences();
//<<< WiZaRd::ConChecker [eWombat]

//>>> WiZaRd::AutoHL
	if(thePrefs.IsUseAutoHL() != m_iUseAutoHL-1)
	{
		thePrefs.SetUseAutoHL((sint8)m_iUseAutoHL-1);
		if(thePrefs.IsUseAutoHL() == 0) //globally disabled
		{
			for(UINT i = 0; i < (UINT)theApp.downloadqueue->GetFileCount(); i++)
				theApp.downloadqueue->GetFileByIndex(i)->SetPrivateMaxSources(thePrefs.GetMaxSourcePerFileDefault());
		}
	}
	thePrefs.SetMaxSourcesHL((uint16)m_iMaxSources);
	thePrefs.SetMaxAutoHL((uint16)m_iMaxPerFileSources);
	thePrefs.SetMinAutoHL((uint16)m_iMinPerFileSources);
	thePrefs.SetAutoHLUpdateTimer((uint16)m_iAHLUpdate);
//<<< WiZaRd::AutoHL

//>>> WiZaRd::Payback first	
	thePrefs.SetPaybackFirst((uint8)m_iPaybackFirst);
//<<< WiZaRd::Payback first

//>>> Spike2::Emulate other
	thePrefs.SetEmueDonkey(m_bEmulateEdonkey);
	thePrefs.SetEmueDonkeyHybrid(m_bEmulateEdonkeyHybrid);
	thePrefs.SetEmuMLDonkey(m_bEmulateMLdonkey);
	thePrefs.SetEmuShareaza(m_bEmulateShareaza);
	thePrefs.SetEmuLphant(m_bEmulateLphant);
//<<< Spike2::Emulate other

//>>> WiZaRd::PNCheck/EMF
	if(m_sUserPW != HIDDEN_PASSWORD || m_sUserName != thePrefs.GetUserName())
		thePrefs.SetUserPWCombo(m_sUserName, (m_sUserPW != HIDDEN_PASSWORD) ? m_sUserPW : thePrefs.GetUserPW());	
	thePrefs.SetCheckPNCount(m_bCheckPNs);
	if(m_bFriendsEntry != thePrefs.IsFriendlistEntry(true))
	{
		thePrefs.SetFriendlistEntry(m_bFriendsEntry);
		if(thePrefs.IsFriendlistEntry(false)) //we are authed and want to enter...
			DoFriendListEntry(true);
		else if(!m_bFriendsEntry) //the entry was disabled...
			DoFriendListEntry(false);
	}
	if(m_bAutoUpdateFriends != thePrefs.IsAutoUpdateFriendList(true))
	{
		thePrefs.SetAutoUpdateFriendList(m_bAutoUpdateFriends);
		if(thePrefs.IsAutoUpdateFriendList(false))
			theApp.emuledlg->chatwnd->m_FriendListCtrl.SendMessage(WM_COMMAND, MP_EMF_LOADFRIENDS, 0);
	}
//<<< WiZaRd::PNCheck/EMF

	if(thePrefs.GetToolbarLabelStyle() != (uint8)m_iToolbarLabelStyle)
	{
		thePrefs.SetToolbarLabelStyle((uint8)m_iToolbarLabelStyle);	//>>> shadow2004::Toolbar
		theApp.emuledlg->InvalidateButtons(); //>>> WiZaRd::Toolbar
	}

//>>> shadow2004::IP2Country [EastShare]
	//Check if ip2country is loaded at this point
	if (!theApp.ip2country->IsIP2Country())
		theApp.ip2country->Load();
	thePrefs.SetIP2CountryNameMode((uint8)m_iI2CCaption);
	thePrefs.SetIP2CountryShowFlag(m_bI2CShowFlag);
	theApp.ip2country->Refresh();//refresh passive windows
//<<< shadow2004::IP2Country [EastShare]

//>>> JvA::SLS [enkeyDEV]
	thePrefs.SetSaveLoadSource(m_bSLSCheck);
	thePrefs.SetActivationLimitSLS((uint8)m_iSLSActivationLimit);
	thePrefs.SetSourcesToSaveSLS((uint8)m_iSLSSaveValue);
//<<< JvA::SLS [enkeyDEV]

//>>> shadow2004::FDC [BlueSonicBoy]
	thePrefs.SetFDCEnabled(m_bFDCEnabled);
	thePrefs.SetFDCDoubleEnabled(m_bFDCDouble);
	thePrefs.SetFDCSensitivity(100 - (uint8)m_iFDCSense);
//<<< shadow2004::FDC [BlueSonicBoy]

//>>> shadow2004::minQR [CB]
	thePrefs.SetMinQR(m_bUseMinQR);
//<<< shadow2004::minQR [CB]

//>>> shadow2004::InfiniteQueue [SLUGFILLER]
	thePrefs.SetInfiniteQueue(m_bInfiniteQueue);
//<<< shadow2004::InfiniteQueue [SLUGFILLER]

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgeMuleFuture::LoadSettings(void)
{   
}

void CPPgeMuleFuture::OnDestroy()
{

	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	m_htiMoreTweaksGroup = NULL;

	m_htiMultipleInstances = NULL;
	m_bMultipleInstances = false;

	m_htiClientDataRate = NULL;
	m_uiClientDataRate = 0;

	m_htiFUChunks = NULL;
	m_uiFUChunks = 0;

//>>> WiZaRd::AutoHL
	m_htiAutoHL = NULL;

	m_htiUseAutoHLRadio = NULL;
	m_htiUseAutoHLPerFile = NULL;
	m_htiUseAutoHLOn = NULL;
	m_htiUseAutoHLOff = NULL;
	m_iUseAutoHL = 0;

	m_htiMaxSources = NULL;
	m_iMaxSources = 0;

	m_htiMaxPerFileSources = NULL;
	m_iMaxPerFileSources = 0;

	m_htiMinPerFileSources = NULL;
	m_iMinPerFileSources = 0;

	m_htiAHLUpdate = NULL;
	m_iAHLUpdate = 0;
//<<< WiZaRd::AutoHL

//>>> WiZaRd::Payback first	
	m_htiPaybackFirstRadio = NULL;
	m_htiPaybackDisabled = NULL;
	m_htiPaybackConst = NULL;
	m_htiPaybackVar = NULL;
	m_htiPaybackAuto = NULL;
	m_iPaybackFirst = 0;
//<<< WiZaRd::Payback first

//>>> Spike2::Emulate other
	m_htiEmulateGroup = NULL;

	m_htiEmulateEdonkey = NULL;
	m_htiEmulateEdonkeyHybrid = NULL;
	m_htiEmulateMLdonkey = NULL;
	m_htiEmulateShareaza = NULL;
	m_htiEmulateLphant = NULL;
//<<< Spike2::Emulate other

//>>> WiZaRd::PNCheck/EMF
	m_htiEMFSupport = NULL;
	m_htiUserName = NULL;
	m_htiUserPW = NULL;
	m_htiCheckPNs = NULL;
	m_htiFriendsEntry = NULL;
	m_htiAutoUpdateFriends = NULL;

	m_sUserName = _T("");
	m_sUserPW = _T("");
	m_bCheckPNs = false;
	m_bFriendsEntry = false;
	m_bAutoUpdateFriends = false;
//<<< WiZaRd::PNCheck/EMF

//>>> shadow2004::Toolbar
	m_htiDisplayGroup = NULL;
	m_htiTLabel = NULL;
	m_htiTLabelOn = NULL;
	m_htiTLabelOff = NULL;
	m_htiTLabelActive = NULL;
	m_htiTLabelOver = NULL;
	m_htiTLabelMulti = NULL;
	m_iToolbarLabelStyle = 0;
//<<< shadow2004::Toolbar

//>>> shadow2004::IP2Country [EastShare]
	m_htiI2CGroup = NULL;
	m_htiI2C2Letter = NULL;
	m_htiI2C3Letter = NULL;
	m_htiI2CFullCaption = NULL;
	m_htiI2CShowFlag = NULL;
	m_iI2CCaption = 0;
	m_bI2CShowFlag = false;
//<<< shadow2004::IP2Country [EastShare]

//>>> WiZaRd::IntelliFlush
	m_htiSystemGroup = NULL;
	m_htiFileBufferGroup = NULL;
	m_htiFileBufferSize = NULL;
	m_htiFileBufferTime = NULL;
	m_htiIntelliFlushCheck = NULL;
	m_iFileBufferSize = 0;
	m_iFileBufferTime = 0;
	m_bIntelliFlush = false;
//<<< WiZaRd::IntelliFlush

//>>> WiZaRd::ConChecker [eWombat]
	m_htiConcheckerGroup = NULL;
	m_htiConcheckerActive = NULL;
	m_htiConcheckerPingtypeRadio = NULL;
	m_htiConcheckerPingICMP = NULL;
	m_htiConcheckerPingRAW = NULL;
	m_htiConcheckerTTL = NULL;
	m_htiConcheckerPingtimeout = NULL;
	m_bConcheckerActive = false;
	m_iConcheckerPingtype = 0;
	m_iConcheckerTTL = 0;
	m_iConcheckerPingtimeout = 0;
//<<< WiZaRd::ConChecker [eWombat]

//>>> JvA::SLS [enkeyDEV]
	m_htiSLSGroup = NULL;
	m_htiSLSCheck = NULL;
	m_htiSLSActivationLimit = NULL;
	m_htiSLSSaveValue = NULL;
	m_bSLSCheck = false;
	m_iSLSActivationLimit = 0;
	m_iSLSSaveValue = 0;
//<<< JvA::SLS [enkeyDEV]

//>>> shadow2004::FDC [BlueSonicBoy]
	m_htiFDCGroup		= NULL;
	m_htiFDCEnabled		= NULL;
	m_htiFDCDouble		= NULL;
	m_htiFDCSensitivity = NULL;
	m_bFDCEnabled		= false;
	m_bFDCDouble		= false;
	m_iFDCSense			= 0;
//<<< shadow2004::FDC [BlueSonicBoy]

//>>> shadow2004::minQR [CB]
	m_htiMinQR = NULL;
	m_bUseMinQR = false;
//<<< shadow2004::minQR [CB]

//>>> shadow2004::InfiniteQueue [SLUGFILLER]
	m_htiInfiniteQueue = NULL;
	m_bInfiniteQueue = false;
//<<< shadow2004::InfiniteQueue [SLUGFILLER]


	CPropertyPage::OnDestroy();
}

LRESULT CPPgeMuleFuture::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if (wParam == IDC_EMULEFUTURE_OPTS)
	{
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS) // NEO: FIX - [TreeControl] 
			return 0;
		SetModified();
	}
	return 0;
}